/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture.atlas.sources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;

public class SingleFile
implements SpriteSource {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<SingleFile> CODEC = RecordCodecBuilder.mapCodec(p_261903_ -> p_261903_.group((App)ResourceLocation.CODEC.fieldOf("resource").forGetter(p_261913_ -> p_261913_.resourceId), (App)ResourceLocation.CODEC.optionalFieldOf("sprite").forGetter(p_261615_ -> p_261615_.spriteId)).apply((Applicative)p_261903_, SingleFile::new));
    private final ResourceLocation resourceId;
    private final Optional<ResourceLocation> spriteId;

    public SingleFile(ResourceLocation p_261658_, Optional<ResourceLocation> p_261712_) {
        this.resourceId = p_261658_;
        this.spriteId = p_261712_;
    }

    @Override
    public void run(ResourceManager p_261920_, SpriteSource.Output p_261578_) {
        ResourceLocation $$2 = TEXTURE_ID_CONVERTER.idToFile(this.resourceId);
        Optional<Resource> $$3 = p_261920_.getResource($$2);
        if ($$3.isPresent()) {
            p_261578_.add(this.spriteId.orElse(this.resourceId), $$3.get());
        } else {
            LOGGER.warn("Missing sprite: {}", (Object)$$2);
        }
    }

    @Override
    public SpriteSourceType type() {
        return SpriteSources.SINGLE_FILE;
    }
}

